<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/merchant',[WebController::class,'merchant_home']);
Route::get('/customer',[WebController::class,'customer_home']);
Route::get('/merchant/registration',[WebController::class,'merchant_registration']);
Route::get('/merchant/otp',[WebController::class,'merchant_otp']);
Route::get('/merchant/onboard',[WebController::class,'merchant_onboard']);
Route::get('/merchant/demo',[WebController::class,'merchant_demo']);
Route::post('/merchant/demo/request',[WebController::class,'merchant_demo_post']);
Route::get('/merchant/demo/completed',[WebController::class,'merchant_completed']);
Route::get('/merchant/success',[WebController::class,'merchant_success']);
Route::get('/merchant/tnc',[WebController::class,'merchant_tnc']);
Route::get('/customer/tnc',[WebController::class,'customer_tnc']);

Route::get('/merchant/privacypolicy',[WebController::class,'privacy_policy']);
Route::get('/customer/privacypolicy',[WebController::class,'privacy_policy']);

Route::get('/ourteam',[WebController::class,'our_team']);
Route::get('/contactus',[WebController::class,'contactus']);
Route::post('/contactus/api',[WebController::class,'contact_api']);

Route::post('/newsletter',[WebController::class,'newsletter_api']);


Route::post('/search',[WebController::class,'search']);



Route::get('/',[WebController::class,'merchant_home']);
Route::get('/deals', [WebController::class,'home']);
Route::get('/vendor',[WebController::class,'vendor']);
Route::get('/category',[WebController::class,'category']);
Route::get('/vendor/{id}',[WebController::class,'vendor_db']);
Route::get('/category/{id}',[WebController::class,'category_db']);

Route::get('/deals/viewall/{id}',[WebController::class,'view_all_db']);


//Other Vendor
Route::get('/home/vendor',[WebController::class,'vendorlanding']);


//Other Screens
Route::get('/home/investor',[WebController::class,'investor']);
Route::get('/home/investor/id',[WebController::class,'investor_id']);

Route::get('/home/jobs',[WebController::class,'jobs']);
Route::get('/home/jobs/{id}',[WebController::class,'jobs_id']);

Route::get('/home/press',[WebController::class,'press']);
Route::get('/home/press/{id}',[WebController::class,'press_id']);

Route::get('/home/otherpages/{id}',[WebController::class,'otherpages']);


Route::get('/home/report',[WebController::class,'report']);
Route::get('/home/report/thankyou',[WebController::class,'report_thankyou']);

Route::get('/home/faq',[WebController::class,'faq']);
Route::get('/home/faq/category/{id}',[WebController::class,'faq_category']);
Route::get('/home/faq/selected/{id}',[WebController::class,'faq_category']);
Route::get('/home/faq/search',[WebController::class,'faq_search']);
