@php

use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Vendor;
use App\Models\Location;
use App\Models\VendorLocation;

@endphp

@extends('mobile_mainlayout_landing')


@section('content')

	<div class="event-section section mt-4">
	    <div class="container">

	        <div class="row">

	        
	            <div class="col-12 max-mb-30" data-aos="fade-up">
	                <div class="register-box white_bg">
	                    <div class="row register_block">
	                        <div class="col-lg-7 mob_100w">
	                            @if(!is_null($vendor->image))
	                            <img class="" src="{{env('TPORTAL_URL')}}{{$vendor->image}}" alt="" style="border-radius:12px 12px 0px 0px;">
	                            @endif
	                        </div>
	                        <div class="col-lg-5 mob_100w">
	                            <div class="mt-4"style="padding:16px" >
	                                
	                                <h3 class="font_32 black mt-4 mb-2">{{$vendor->name}}</h3>
	                                <div class="desc urban_light black mb-4">{!!$vendor->description!!}</div>
	                            </div>
	                        </div>
	                    </div>
	                </div>
	            </div>

	        </div>


	    </div>
	</div>




<?php
/*
	<div class="section">
	    <div class="container">
	        <div class="row">
	            <div class="col-12">
	                <!-- Section Title Start -->
	                <div class=" location_border text-center" data-aos="fade-up">
	                    <div class="event-entry-meta" style="text-align: left;">

	                    	@php
	                    	$vendorlocation = VendorLocation::where('vendorid',$vendor->id)->get();
	                    	@endphp

	                    	@foreach($vendorlocation as $vlocation)

	                        <div class="meta-item">
	                            <span class="meta_bg_gold">{{Location::where('id',$vlocation->location)->first()->name}}</span>
	                        </div>
	                        @endforeach
	                    </div>
	                </div>
	                <!-- Section Title End -->
	            </div>
	        </div>
	    </div>
	</div>
	
	*/
	?>



	<div class="section">
	    <div class="container">
			<div class="row">

			    <div class="col-lg-12 col-12 order-lg-1 max-mb-50">

			        <!-- Event Details Wrapper Start -->
			        <div class="event-details-wrapper">
			            <div class="map-area">
			                <iframe class="event-map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7924.002560343778!2d39.25997911434596!3d-6.769696168081774!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x185c4c4613f44f5f%3A0xb068270e637d04ed!2sShoppers%20Plaza%20Mikocheni!5e0!3m2!1sen!2stz!4v1654687021387!5m2!1sen!2stz"></iframe>
			            </div>
			        </div>
			        <!-- Event Details Wrapper End -->
			    </div>
			    
			    <div class="col-lg-12 col-12 max-mb-50">
			                        @php
	                            	$deals = Deals::where('vendorid',$vendor->id)->get();
	                            	@endphp
	                                <h3 class="font_24 white mt-4 mb-2">Deals by {{$vendor->name}}</h3>
	                                <div class="row">
	                                	@foreach($deals as $deal)
	                                	@php
	                                	$deal_name = json_decode($deal->name);
	                                	@endphp
	                                	
	                                	<div class="col-lg-6 col-md-6 max-mb-30 mob_50w">
                                            <div class="deal">
                                                <div class="thumbnail">
                                                    <a href="/vendor/{{$vendor->id}}" class="image">
                                                        <img src="{{env('TPORTAL_URL')}}{{$deal->featured_image}}" class="vendor_image"  alt="{{$vendor->name}}"></a>
                                                </div>
                                                <div>
                                                    <p class="meta urban_bold gold mb-0">{{$deal_name->en}}</p>
                                                    <h3 class="title white font_18 mb-0"><a href="/vendor/{{$vendor->id}}">{{$vendor->name}}</a></h3>
                                                    <p class="meta urban_light white">{{$vendor->address}}</p>
                                                </div>
                                            </div>
                                        </div>
	                                	@endforeach
	                                </div>
			    </div>
			</div>
		</div>
	</div>



@endsection