@php

use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Vendor;




$cat_name = json_decode($category->name)

@endphp

@extends('mainlayout_landing')


@section('content')


	<!-- Event Page Banner Start -->
	<div class="section overlay mt-4 padbtm_36">
	    <div class="container">
	        <div class="col-12">
	           
	            <div class="banner_container overlay" style="border-radius:15px;">
	               @if(!is_null($category->featured_image))
	              <img src="{{env('TPORTAL_URL')}}{{$category->featured_image}}" alt="{{$cat_name->en}}" style="width:100%;border-radius:15px;">
	              @else
	              <img src="/assets/images/tiger/category_wide.png" alt="{{$cat_name->en}}" style="width:100%;border-radius:15px;">
	              @endif
	              
	              <div class="top-left">
	              	<span class="sub-title handwritting gold">Inspired By Deals</span>
	              	<h2 class="title bold_text font_48 white">{{$cat_name->en}}</h2>
	              </div>
	        </div>
	    </div>
	</div>
	<!-- Event Page Banner End -->

	<!--Search-->
	<?php
	/*
	<div class="section mt-4 padbtm_36">
	    <div class="container">
	        <div class="row sidebar-widget">
	            <div class="col-4 sidebar-widget-content">
	                <div class="sidebar-widget-search">
	                    <form action="#">
	                        <input type="text" placeholder="Search...">
	                        <button><i class="fas fa-search"></i></button>
	                    </form>
	                </div>
	            </div>
	        </div>
	    </div>
	</div>
	*/
	?>


	<!-- Featured Section Start -->
	<div class="section mt-4 padbtm_36">
	    <div class="container">

	        <!-- Course Top Bar Start -->
	        <div class="row justify-content-between align-items-center max-mb-20">
	            <div class="col-12 max-mb-10">
	                <h3 class="font_24 bold_text white" style="display: inline;">Deals</h3>
	            </div>
	        </div>
	        <!-- Course Top Bar End -->

	        <!-- Deal Wrapper Start -->
	        <div class="row max-mb-30">

	        	@forelse($vendors as $vendor)
	        	@php
	        	$v_deal = Deals::where('vendorid',$vendor->id)->get();
	        	@endphp
	        	
	        	@if(!is_null($v_deal))
	        	@foreach($v_deal as $deal)
	            <!-- Deal Start -->
	            <div class="col-lg-3 col-md-6 max-mb-30 mob_50w" data-aos="fade-up">
	                <div class="deal">
	                    <div class="thumbnail">
	                        <a href="/vendor/{{$vendor->id}}" class="image">
	                            <img src="{{env('TPORTAL_URL')}}{{$deal->featured_image}}" class="vendor_image"  alt="{{$vendor->name}}">
	                        </a>
	                    </div>
	                    <div>
	                        <h3 class="title white font_18 mt-4 mb-0"><a href="">{{$vendor->name}}</a></h3>
	                        <p class="meta urban_light white">{{$vendor->address}}</p>
	                    </div>
	                </div>
	            </div>
	            @endforeach
	            @endif
	            <!-- Deal End -->
	            @empty
	            <div class="col-lg-3 col-md-6 max-mb-30 mob_50w" data-aos="fade-up">
	                <div class="deal">
	                    <div>
	                        <h3 class="title white font_18 mt-4 mb-0"><a href="">No Deals Found :(</a></h3>
	                </div>
	            </div>
	            @endforelse

	        </div>
	        <!-- Courses Wrapper End -->


	    </div>
	</div>
	<!-- Featured Section End -->



@endsection