@php

use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Vendor;
use App\Models\VendorLanding;

$categories = Category::all();

$dealtypes = DealTypes::all();

$vendorlanding = VendorLanding::where('id','1')->first();

@endphp

@extends('mobile_mainlayout_landing')


@section('content')



		<div class="event-section section mt-4 padbtm_32">
            <div class="container">
                <div class="row">
                    <div class="col-12 max-mb-30" data-aos="fade-up">
                        <div class="banner_container" style="border-radius:15px;">
			              <img src="https://tigeradmin.testing.co.tz{{$page->featured_image}}" alt="" style="width:100%;border-radius:15px;">
			              
			              <div class="top-left">
			              	<h2 class="title bold_text font_24 white">Career</h2>
			              </div>
			        	</div>
                    </div>
                </div>
            </div>
        </div>
        
        
         <div class="event-section section">
            <div class="container">
                <div class="row">
                    <div class="col-12 max-mb-30" data-aos="fade-up">
                        <div class="banner_container" style="border-radius:15px;">
			              <div>
			              	<p class="text font_16 white">If love for positive societal impact and fun drive you, welcome onboard!</p>
			              </div>
			        	</div>
                    </div>
                </div>
            </div>
        </div>

	    <div class="event-section section mt-4">
		    <div class="container">
		        <div class="row">	        
		            <div class="col-12 max-mb-30" data-aos="fade-up">
		                <div class="register-box gold_bg">
		                    <div class="row register_block">
		                        <div class="col-lg-5 mob_100w">
		                            <div class="mt-4 mb-4" style="padding-left:15px">
		                                <h3 class="font_24 black mb-2">Available Roles</h3>
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</div>


		 <!-- Jobs Section Start -->
        <div class="section section-padding-bottom fix">
            <div class="container">

                <!-- Jobs Wrapper Start -->
                <div class="row row-cols-1 no-gutters" style="padding-left:15px;padding-right:15px;">

                @forelse($jobs as $job)
                    <!-- Jobs Start -->
                    <div class="blog-3 col" data-aos="fade-up">
                        <div class="row row-cols-lg-2 row-cols-1 max-mb-n30">
                            <div class="col max-mb-30">
                                <div class="info pt-0">
                                    @php
                                    $title = json_decode($job->title);
                                     $link = json_decode($job->file);
                                      $description = json_decode($job->description);
                                    @endphp
                                    <h3 class="title white font_24"><a href="/home/jobs/{{$job->id}}">{{$title->en}}</a></h3>
                                    <div class="desc urban">
                                        <p>Deadline : {{$job->deadline}}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Jobs End -->
                @empty
                <p>No Jobs Available.</p>
                @endforelse

                </div>
                <!-- Jobs Wrapper End -->

            </div>
        </div>
        <!-- Jobs Section End -->






@endsection