<?php

namespace App\Http\Controllers;


use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Faq;
use App\Models\FaqCategories;
use App\Models\InfringementReport;
use App\Models\InvestorRelation;
use App\Models\Location;
use App\Models\Pages;
use App\Models\Post;
use App\Models\Slider;
use App\Models\Vacancy;
use App\Models\Vendor;
use App\Models\VendorLanding;
use App\Models\VendorLocation;
use App\Models\WebLanding;
use Jenssegers\Agent\Agent;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;


use Illuminate\Http\Request;

class WebController extends Controller
{


    //Updates

    public function merchant_home()
    {
        $agent = new Agent();
        $merchant = DB::table('merchant_landings')->where('id','1')->first();

        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_home',['merchant'=>$merchant]);
        }
        else
        {
        return view('landing.merchant_home',['merchant'=>$merchant]);
        }
    }

    public function customer_home()
    {
        $agent = new Agent();
        $merchant = DB::table('merchant_landings')->where('id','1')->first();
        
        
        if($agent->isMobile())
        {
            return view('landing.mobile.customer_home',['merchant'=>$merchant]);
        }
        else
        {
        return view('landing.customer_home',['merchant'=>$merchant]);
        }
    }


    public function merchant_registration()
    {
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_registration');
        }
        else
        {
        return view('landing.merchant_registration');
        }
    }

    public function merchant_otp()
    {
         return view('landing.otp');
    }

    public function merchant_onboard()
    {
        return view('landing.merchant_onboard');
    }
    
    public function merchant_demo()
    {
         $agent = new Agent();
        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_request_demo');
        }
        else
        {
        return view('landing.merchant_request_demo');
        }
    }
    
    public function contact_api(Request $request)
    {
        $client = new Client();
        $response = $client->request('POST', 'https://api.hsforms.com/submissions/v3/integration/secure/submit/26137210/6105b9e1-4a4b-45af-929a-d41c5f6d8f0b', [
        'headers'=>['Authorization'=>"Bearer pat-eu1-b7d2aaea-0ca1-414f-a7c4-dedb11db01a0",
                    'Accept'        => 'application/json'],
        'json' => ["fields"=> [
                [
                  "name"=> "email",
                  "value"=> $request->email
                ],
                [
                  "name"=> "subject",
                  "value"=> $request->subject
                ],
                [
                  "name"=> "message",
                  "value"=> $request->message
                ]
            
              ]]
              ]);
              
        return redirect('/merchant/success');
    }
    
    public function merchant_test()
    {
        $client = new Client();
        $response = $client->request('POST', 'https://api.hsforms.com/submissions/v3/integration/secure/submit/26137210/af759235-b537-4686-917b-223d2d7c0aa9', [
        'headers'=>['Authorization'=>"Bearer pat-eu1-b7d2aaea-0ca1-414f-a7c4-dedb11db01a0",
                    'Accept'        => 'application/json'],
        'json' => ["fields"=> [
                [
                  "name"=> "firstname",
                  "value"=> $request->first_name
                ],
                [
                  "name"=> "lastname",
                  "value"=> $request->last_name
                ],
                [
                  "name"=> "phone",
                  "value"=> $request->phone
                ],
                [
                  "name"=> "company",
                  "value"=> $request->business_name
                ],
                [
                  "name"=> "email",
                  "value"=> $request->email
                ],
                [
                  "name"=> "businesslocation",
                  "value"=> $request->location
                ]
            
              ]]
              ]);
    }
    public function merchant_demo_post(Request $request)
    {
        
        $client = new Client();
        $response = $client->request('POST', 'https://api.hsforms.com/submissions/v3/integration/secure/submit/26137210/af759235-b537-4686-917b-223d2d7c0aa9', [
        'headers'=>['Authorization'=>"Bearer pat-eu1-b7d2aaea-0ca1-414f-a7c4-dedb11db01a0",
                    'Accept'        => 'application/json'],
        'json' => ["fields"=> [
                [
                  "name"=> "firstname",
                  "value"=> $request->first_name
                ],
                [
                  "name"=> "lastname",
                  "value"=> $request->last_name
                ],
                [
                  "name"=> "phone",
                  "value"=> $request->phone
                ],
                [
                  "name"=> "company",
                  "value"=> $request->business_name
                ],
                [
                  "name"=> "email",
                  "value"=> $request->email
                ],
                [
                  "name"=> "businesslocation",
                  "value"=> $request->location
                ]
            
              ]]
              ]);
              
        return redirect('/merchant/demo/completed');
    }
    
    public function newsletter_api(Request $request)
    {
        
       $validated = $request->validate([
           'email' => 'email:rfc,dns']);
    /*            
            $mailchimp = new \MailchimpMarketing\ApiClient();
            $mailchimp->setConfig([
                'apiKey' => '600e0ea13757b47bbfae5f67b000ddce-us9',
                'server' => 'us9',
            ]);
            
      try {
    $response = $mailchimp->lists->addListMember('4f24d9315e', [
        "email_address" => $request->email,
        "status" => "subscribed",
        
            ]);
            //print_r($response);
        }  catch (MailchimpMarketing\ApiException $e) {
            echo $e->getMessage();
        }
        
        
        
        */
        
        
        //hubspot api
        
        $client = new Client();
        $response = $client->request('POST', 'https://api.hsforms.com/submissions/v3/integration/secure/submit/26137210/bfa726f4-9352-4507-85fc-d7cdc4ec8b61', [
        'headers'=>['Authorization'=>"Bearer pat-eu1-b7d2aaea-0ca1-414f-a7c4-dedb11db01a0",
                    'Accept'        => 'application/json'],
        'json' => ["fields"=> [
                
                [
                  "name"=> "email",
                  "value"=> $request->email
                ]
            
              ]]
              ]);
              
              
            $agent = new Agent();

        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_success');
        }
        else
        {
        return view('landing.merchant_success');
        }
    }
    public function merchant_completed()
    {
         $agent = new Agent();
        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_completed');
        }
        else
        {
        return view('landing.merchant_completed');
        }
    }
    

    public function merchant_success()
    {
         $agent = new Agent();
        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_success');
        }
        else
        {
        return view('landing.merchant_success');
        }
    }

    public function merchant_tnc()
    {
         $agent = new Agent();
         $tnc = DB::table('term_conditions')->where('id','1')->first();

        if($agent->isMobile())
        {
            return view('landing.mobile.merchant_tnc',['tnc'=>$tnc]);
        }
        else
        {
        return view('landing.merchant_tnc',['tnc'=>$tnc]);
        }
    }
    public function customer_tnc()
    {
         $agent = new Agent();
         $tnc = DB::table('term_condition_customers')->where('id','1')->first();

        if($agent->isMobile())
        {
            return view('landing.mobile.customer_tnc',['tnc'=>$tnc]);
        }
        else
        {
        return view('landing.customer_tnc',['tnc'=>$tnc]);
        }
    }
    
    public function privacy_policy()
    {
         $agent = new Agent();
         $tnc = DB::table('term_conditions')->where('id','1')->first();

        if($agent->isMobile())
        {
            return view('landing.mobile.privacy_policy',['tnc'=>$tnc]);
        }
        else
        {
        return view('landing.privacy_policy',['tnc'=>$tnc]);
        }
    }



    //
    public function home()
    {
        $fromdb = 'yes';
        if ($fromdb =='yes') 
        {
            $landing = WebLanding::find('1');
            
            /*
            //Title
            $title;
            $caption;
            
            //Register
            $register_link_label;
            $register_link;
            $how_it_works;
            $how_it_works_label;
            $google_play;
            $ios;
            
            
            //featuredd
            $featured1;
            
            $category_1;
            $category_2;
            $category_3;
            $category_4;
            $category_5;
            $category_6;
            $category_7;
            $category_8;
            $category_9;
           
            return view('web.landing_db',['landing'=>$landing,
            'category_1'=>$category_1,'category_2'=>$category_2,'category_3'=>$category_3,'category_4'=>$category_4,'category_5'=>$category_5,'category_6'=>$category_6,
            'category_7'=>$category_7,'category_8'=>$category_8,'category_9'=>$category_9]);*/
            
            
            
        $agent = new Agent();
        $merchant = DB::table('merchant_landings')->where('id','1')->first();

        if($agent->isMobile())
        {
            return view('web.mobile.landing_db',['landing'=>$landing,'merchant'=>$merchant]);
        }
        else
        {
            return view('web.landing_db',['landing'=>$landing,'merchant'=>$merchant]);
        }
        } 
        else {
           return view('web.landing');
        }
        
        
    }

    

    public function vendor()
    {
        return view('web.vendor');
    }

    public function vendor_db($id)
    {
        $vendor = Vendor::where('id',$id)->first();
        
        
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('web.mobile.vendor_db',['vendor'=>$vendor]);
        }
        else
        {
        return view('web.vendor_db',['vendor'=>$vendor]);
        }
    }



    public function category()
    {
        return view('web.category');
    }

    public function category_db($id)
    {
        $category = Category::where('id',$id)->first();

        $vendors = Vendor::where('category',$category->id)->get();
        
        
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('web.mobile.category_db',['vendors'=>$vendors,'category'=>$category]);
        }
        else
        {
            return view('web.category_db',['vendors'=>$vendors,'category'=>$category]);
        }
    }
    
    public function view_all_db($id)
    {
        $deals = Deals::where('dealtypeid',$id)->get();
        $deal_type = DealTypes::where('id',$id)->first();
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('web.mobile.viewall_db',['deals'=>$deals,'deal_type'=>$deal_type]);
        }
        else
        {
            return view('web.viewall_db',['deals'=>$deals,'deal_type'=>$deal_type]);
        }
    }




    //VENDOR


    public function vendorlanding()
    {
        

         $fromdb = 'no';
        if ($fromdb =='yes') 
        {
            
            return view('other.vendor_landing_db');
        } 
        else {
           return view('other.vendor_landing');
        }
    }


    public function investor()
    {
        $investor = InvestorRelation::all();
        $page = Pages::where('pagetype','3')->first();
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.invest',['investors'=>$investor,'page'=>$page]);
        }

        else
        {
            return view('other.invest',['investors'=>$investor,'page'=>$page]);
        }
        
    }

    public function invest_id()
    {
        
    }

    public function jobs()
    {
        $jobs = Vacancy::all();
        $page = Pages::where('pagetype','4')->first();
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.jobs',['jobs'=>$jobs,'page'=>$page]);
        }
        else
        {
           return view('other.jobs',['jobs'=>$jobs,'page'=>$page]); 
        }
        
    }

    public function jobs_id($id)
    {
        $job = Vacancy::where('id',$id)->first();
        

        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.jobs_id',['job'=>$job]);
        }
        else
        {
            return view('other.jobs_id',['job'=>$job]);
        }
        
        
    }

    public function press()
    {
        $press = Post::all();
        $agent = new Agent();
        
        $page = Pages::where('pagetype','2')->first();
        
        if($agent->isMobile())
        {
            return view('other.mobile.press',['press'=>$press,'page'=>$page]);
        }

        else
        {
           return view('other.press',['press'=>$press,'page'=>$page]); 
        }
        
    }

    public function press_id($id)
    {
        $press = Post::where('id',$id)->first();
        $other_press = Post::all();
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.press_id',['otherpress'=>$other_press,'press'=>$press]);
        }

        else
        {
           return view('other.press_id',['otherpress'=>$other_press,'press'=>$press]); 
        }
        
    }

    public function otherpages($id)
    {
        $page = Pages::where('id',$id)->first();
        return view('other.content_only',['page'=>$page]);
    }

    public function report()
    {

        return view('other.report');
    }

    public function report_thankyou()
    {
        return view('other.report_thankyou');
    }

    public function faq()
    {
        $faq_cat = FaqCategories::all();
        $banner = DB::table('f_a_q_banners')->where('id','1')->first();
    //dd($banner);
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.faq',['faq_cat'=>$faq_cat,'banner'=>$banner]);
        }
        else
        {
           return view('other.faq',['faq_cat'=>$faq_cat,'banner'=>$banner]); 
        }
        
    }

    public function faq_category($id)
    {   
        $facat = FaqCategories::where('id',$id)->first();
        $faqs = Faq::where('faqcategory',$id)->get();
        $other_faqs = FaqCategories::where('id',"!=",$id)->get();

        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.faq_selected',['faqs'=>$faqs,'category'=>$facat,'others'=>$other_faqs]);
        }

        else
        {
           return view('other.faq_selected',['faqs'=>$faqs,'category'=>$facat,'others'=>$other_faqs]); 
        }
        
    }

    public function faq_selected($id)
    {
        $faq = Faq::where('id',$id)->first();
        
        $other_faqs = Faq::where('id',"!=",$id)->get();

        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.faq_selected',['faq'=>$faq,'others'=>$other_faqs]);   
        }
        else
        {
            return view('other.faq_selected',['faq'=>$faq,'others'=>$other_faqs]);
        }
        
    }

    public function faq_search()
    {
        $agent = new Agent();

        if($agent->isMobile())
        {
            return view('other.mobile.faq_search_result');
        }
        else
        {
            return view('other.faq_search_result'); 
        }   
        
    }
    
    public function our_team()
    {
       $agent = new Agent();
       $team = DB::table('our_teams')->where('id','1')->first();

        if($agent->isMobile())
        {
            return view('landing.mobile.ourteam',['team'=>$team]);
        }
        else
        {
            return view('landing.ourteam',['team'=>$team]); 
        }   
    }
    
    public function contactus()
    {
        $agent = new Agent();
        if($agent->isMobile())
        {
           return view('landing.mobile.contact_form');
        }
        else
        {
            return view('landing.contact_form');
        }
        
    }
    
    
    public function search(Request $request)
    {
        $search = $request->search;
        //DealsQuery for Category, Deals,Vendor
       
        $q_deals = Deals::where('name','LIKE','%'. $search . '%')->orWhere('description','LIKE','%'. $search . '%')->get();
        $q_vendor = Vendor::where('name','LIKE','%'. $search . '%')->orWhere('address','LIKE','%'. $search . '%')->orWhere('description','LIKE','%'. $search . '%')->get();
        $q_categories = Category::where('name','LIKE','%'. $search . '%')->get();
        
         //FAQ Query for FaQs, FAQCategories
        
        $q_faq = Faq::where('question','LIKE','%'. $search . '%')->orWhere('answer','LIKE','%'. $search . '%')->get();
        $q_faqCategories = FaqCategories::where('name','LIKE','%'. $search . '%')->orWhere('description','LIKE','%'. $search . '%')->get();
        
        $agent = new Agent();
        if($agent->isMobile())
        {
           return view('web.mobile.search_results');
        }
        else
        {
            return view('web.search_results',['q_deals'=>$q_deals,'q_vendor'=>$q_vendor,'q_categories'=>$q_categories,'q_faq'=>$q_faq,'q_faqCategories'=>$q_faqCategories]);
        }
    }



}
