@php

use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Vendor;




$dealtype = json_decode($deal_type->type);

@endphp

@extends('mainlayout_landing')


@section('nav_options')
                                    <div class="header-language d-none d-sm-block">
                                     
                                        <a href="/deals">
                                            <span class="text gold" style="text-transform: initial;">Deals</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/home/faq">
                                            <span class="text gold" style="text-transform: initial;">FAQ'S</span>
                                        </a>
                                    </div>
                                    
                                    <div class="header-language d-none d-sm-block">
                                       <a href="#">
                                             <img src="/assets/images/tiger/app_white.png" alt="" style="width:120px">
                                        </a>
                                    </div>
                                    
                                    <div class="header-language d-none d-sm-block">
                                        <a href="#">
                                              <img src="/assets/images/tiger/android_white.png" alt="" style="width:120px">
                                        </a>
                                    </div>

@endsection


@section('content')


	<!-- Event Page Banner Start -->
	<div class="section overlay padbtm_36" style="padding-top:4em">
	    <div class="container">
	        <div class="col-12">
	           
	            <div class="banner_container overlay" style="border-radius:15px;">
	              
	              <img src="{{env('TPORTAL_URL')}}{{$deal_type->featured_image}}" alt="{{$dealtype->en}}" style="width:100%;border-radius:15px;">
	            
	              
	              <div class="top-left">
	              	<h2 class="title bold_text font_48 white">{{$dealtype->en}}</h2>
	              </div>
	        </div>
	    </div>
	</div>
	<!-- Event Page Banner End -->

	<!--Search-->
	<?php
	/*
	<div class="section mt-4 padbtm_36">
	    <div class="container">
	        <div class="row sidebar-widget">
	            <div class="col-4 sidebar-widget-content">
	                <div class="sidebar-widget-search">
	                    <form action="#">
	                        <input type="text" placeholder="Search...">
	                        <button><i class="fas fa-search"></i></button>
	                    </form>
	                </div>
	            </div>
	        </div>
	    </div>
	</div>
	*/
	?>


	<!-- Featured Section Start -->
	<div class="section mt-4 padbtm_36">
	    <div class="container">

	        <!-- Course Top Bar Start -->
	        <div class="row justify-content-between align-items-center max-mb-20">
	            <div class="col-12 max-mb-10">
	                <h3 class="font_24 bold_text white" style="display: inline;">Deals</h3>
	            </div>
	        </div>
	        <!-- Course Top Bar End -->

	        <!-- Deal Wrapper Start -->
	        <div class="row max-mb-30">

	        	@forelse($deals as $deal)
	        	@php
	        	$vendor = Vendor::where('id',$deal->vendorid)->first();
	        	@endphp
	        	
	            <!-- Deal Start -->
	            <div class="col-lg-3 col-md-6 max-mb-30 mob_50w" data-aos="fade-up">
	                <div class="deal">
	                    <div class="thumbnail">
	                        <a href="/vendor/{{$vendor->id}}" class="image">
	                            <img src="{{env('TPORTAL_URL')}}{{$deal->featured_image}}" class="vendor_image"  alt="{{$vendor->name}}">
	                        </a>
	                    </div>
	                    <div>
	                        @if(isset($deal->name))
	                        @php
	                        $deal_name = json_decode($deal->name);
                            @endphp
                            <p class="meta urban_bold gold mb-0">{{$deal_name->en}}</p>
                            @endif
	                        <h3 class="title white font_18 mb-0"><a href="">{{$vendor->name}}</a></h3>
	                        <p class="meta urban_light white">{{$vendor->address}}</p>
	                    </div>
	                </div>
	            </div>
	            <!-- Deal End -->
	            @empty
	            <div class="col-lg-3 col-md-6 max-mb-30 mob_50w" data-aos="fade-up">
	                <div class="deal">
	                    <div>
	                        <h3 class="title white font_18 mt-4 mb-0"><a href="">No Deals Found :(</a></h3>
	                </div>
	            </div>
	            @endforelse

	        </div>
	        <!-- Courses Wrapper End -->


	    </div>
	</div>
	<!-- Featured Section End -->



@endsection