
@extends('mainlayout_landing')

@section('nav_options')
                                    <div class="header-language d-none d-sm-block">
                                     
                                        <a href="/deals">
                                            <span class="text gold" style="text-transform: initial;">Deals</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/home/faq">
                                            <span class="text gold" style="text-transform: initial;">FAQ'S</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/merchant/demo">
                                            <span class="text gold" style="text-transform: initial;">Request Demo</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/merchant/registration" class="btn btn-new_gold" style="background-color: #D4AF37;color:#fff;height:42px; text-transform: initial;">
                                            Register Business
                                        </a>
                                    </div>

@endsection
@section('content')

		<div class="event-section section mt-4 padbtm_32">
            <div class="container">
                <div class="row">
                    <div class="col-12 max-mb-30" data-aos="fade-up">
                        <div class="banner_container" style="border-radius:15px;">
			              <img src="https://tigeradmin.testing.co.tz{{$page->featured_image}}" alt="Snow" style="width:100%;border-radius:15px;">
			              
			              <div class="top-left">
			              	<h2 class="title bold_text font_48 white">Blog</h2>
			              </div>
			        	</div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Jobs Section Start -->
        <div class="section section-padding-bottom fix">
            <div class="container">
                <!-- Jobs Wrapper Start -->
                <div class="row row-cols-1 pad_32">
                    
                    @forelse($press as $post)
                    
                	<!-- Press Start -->
                    <div class="blog-3 col " data-aos="fade-up">
                        <div class="row row-cols-lg-2 row-cols-1 max-mb-n30">
                            <div class="col-lg-4 max-mb-30">
                                <div class="thumbnail">
                                    <a href="/home/press/{{$post->id}}" class="image"><img src="https://tigeradmin.testing.co.tz{{$post->image}}" alt="Image" 
                                    style="    object-fit: cover;height: 200px"></a>
                                </div>
                            </div>
                            <div class="col-lg-8 max-mb-30">
                                <div class="info pt-0">
                                    @php
                                    $title = json_decode($post->title);
                                    $content = json_decode($post->content);
                                    
                                    @endphp
                                    <h3 class="title gold font_24"><a href="/home/press/{{$post->id}}">
                                       {{$title->en}}</a></h3>
                                    <ul class="meta">
                                        <li class="white"><i class="far fa-calendar white"></i>{{$post->created_at}}</li>
                                    </ul>
                                    <div class="desc urban white">
                                        @php
                                        $descr = substr(html_entity_decode($content->en), 3, 220);
                                        $descript = $descr.'...';
                                        @endphp
                                        <p style="padding-right:4.5em">{!!$descript!!}</p>
                                    </div>
                                    <a href="/home/press/{{$post->id}}" class="btn btn-new_gold" style="background-color: #D4AF37;color:#fff;height:36px; text-transform: initial;margin-top:0.25em">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Press End -->
                    
                    @empty
                    
                    @endforelse


                </div>
            </div>
        </div>




@endsection