@php

use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Vendor;
use App\Models\VendorLanding;

$categories = Category::all();

$dealtypes = DealTypes::all();

$vendorlanding = VendorLanding::where('id','1')->first();

@endphp

@extends('other_mainlayout')


@section('content')

    	<div class="event-section section mt-4 padbtm_32">
            <div class="container">

                <div class="row">

                
                    <div class="col-12 max-mb-30" data-aos="fade-up">
                        <div class="register-box gold_bg">
                            <div class="row register_block">
                               
                                <div class="col-lg-6 mob_100w pad_32">
                                    <div class="margtop_2em">
                                        <h2 class="font_32 black mt-4 mb-2">{{$vendorlanding->top_section_title}}</h2>
                                        <p class="desc urban_light black mb-4">{{$vendorlanding->top_section_caption}}</p>
                                    </div>
                                </div>

                                 <div class="col-lg-6 mob_100w">
                                    <img class="" src="{{$vendorlanding->top_section_image}}" alt="">
                                </div>
                            </div>
                        </div>
                    </div>

                </div>


            </div>
        </div>



        <!-- Video Section Start -->
        <div id="video-section-1" class="section position-relative padtb_4em" data-bg-color="#fff">

            <div class="container">

                <!-- Section Title Start -->
                <div class="section-title text-center" data-aos="fade-up">
                    <h2 class="title black">{{$vendorlanding->middle_section_title}}</h2>
                </div>
                <!-- Section Title End -->

                <!-- About Me Video Wrapper Start -->
                <div class="about-me-video-wrapper">

                    <!-- About Me Video Start -->
                    <a href="{{$vendorlanding->middle_section_videolink}}" class="about-me-video video-popup" data-aos="fade-up">
                        <img class="image" src="/assets/images/tiger/vendor_landing_yt.png" alt="">
                        <img class="icon" src="/assets/images/icons/icon-youtube-play.png" alt="">
                    </a>
                    <!-- About Me Video End -->

                </div>
                <!-- About Me Video Wrapper End -->

            </div>

        </div>
        <!-- Video Section End -->


         <!-- About Section Start -->
        <div class="section position-relative section-padding-bottom-160">

            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <!-- About Me Video Wrapper Start -->
                       
                        <!-- About Me Video Wrapper End -->
                        <div style="position: relative;">
                          <img class="image" src="{{$vendorlanding->bottom_section_image_one}}" style="width:100%;">
                          
                          <div class="bottom-right" style="padding: 12px;width:320px;background: #FFFFFF; border: 3px solid #D4AF37; border-radius: 12px;">
                              <p class="black" style="font-size:16px">{{$vendorlanding->bottom_section_testimonial_name_one}}</p>
                              <p class="urban_light" style="font-size:13px">{{$vendorlanding->bottom_section_testimonial_message_one}}</p>
                          </div>
                          
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="about-content max-width-100 pl-60 pl-md-20 pl-sm-0 pl-xs-0 mt-sm-50 mt-xs-50">
                            
                            <h3 class="title bold_text black">{{$vendorlanding->bottom_section_title_one}}</h3>

                            <p>{{$vendorlanding->bottom_section_caption_one}}</p>
                        </div>
                    </div>
                </div>
            </div>


        </div>
        <!-- About Section End -->


        <!-- About Section Start -->
        <div class="section position-relative section-padding-bottom-160">

            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5">
                        <div class="about-content max-width-100 pl-60 pl-md-20 pl-sm-0 pl-xs-0 mt-sm-50 mt-xs-50">
                            <h3 class="title bold_text black">{{$vendorlanding->bottom_section_title_two}}</h3>

                            <p>{{$vendorlanding->bottom_section_caption_two}}</p>
                        </div>
                    </div>

                    <div class="col-lg-7">
                        <!-- About Me Wrapper Start -->
                       
                        <!-- About Me  Wrapper End -->
                        <div style="position: relative;">
                          <img class="image" src="{{$vendorlanding->bottom_section_image_two}}" style="width:100%;">
                          
                          <div class="bottom-right" style="padding: 12px;width:320px;background: #FFFFFF; border: 3px solid #D4AF37; border-radius: 12px;">
                              <p class="black" style="font-size:16px">{{$vendorlanding->bottom_section_testimonial_name_two}}</p>
                              <p class="urban_light" style="font-size:13px">{{$vendorlanding->bottom_section_testimonial_message_two}}</p>
                          </div>
                          
                        </div>
                    </div>

                    
                </div>
            </div>


        </div>
        <!-- About Section End -->


        <div class="event-section section mt-4 padbtm_32" >
            <div class="container">

                <div class="row">

                    <div class="center_content">
                        <h2 class="title lightText" style="text-align:center;">Let's Talk More</h2>
                    </div>

                
                    <div class="col-12 max-mb-30" data-aos="fade-up">
                        <div class="register-box"  style="padding: 24px; background: linear-gradient(270deg, #D4AF37 0%, rgba(212, 175, 55, 0.4) 100%);">
                            <div class="row register_block">
                               
                                <div class="col-lg-4">
                                    <div class="">
                                        <p class="urban black font_14">Sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, </p>
                                    </div>

                                </div>
                                <div class="col-lg-8">
                                    <div class="contact-form ">
                                        <form action="#" id="contact-form" method="post">
                                            <div class="row max-mb-n30">
                                                <div class="col-md-4 col-12 max-mb-30">
                                                    <input type="text" placeholder="Your Name *" name="name" style="background-color:#fff">
                                                </div>
                                                <div class="col-md-4 col-12 max-mb-30">
                                                    <input type="email" placeholder="Email *" name="email" style="background-color:#fff">
                                                </div>
                                                <div class="col-2 text-left max-mb-30">
                                                    <button class="btn btn-dark btn-width-180 btn-height-60">Submit</button>
                                                </div>
                                                
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>


            </div>
        </div>






@endsection