@php

use App\Models\Category;
use App\Models\Deals;
use App\Models\DealTypes;
use App\Models\Vendor;
use App\Models\Slider;


$deal_type = DealTypes::where('id','1')->first();
$deals = Deals::where('dealtypeid',$deal_type->id)->paginate(4);


@endphp

@extends('mainlayout_landing')

@push('extracss')




<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
 <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />
@endpush

@section('nav_options')
                                    <div class="header-language d-none d-sm-block">
                                     
                                        <a href="/deals">
                                            <span class="text gold" style="text-transform: initial;">Deals</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/home/faq">
                                            <span class="text gold" style="text-transform: initial;">FAQ'S</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/merchant/demo">
                                            <span class="text gold" style="text-transform: initial;">Request Demo</span>
                                        </a>
                                    </div>
                                    <div class="header-language d-none d-sm-block">
                                      
                                        <a href="/merchant/registration" class="btn btn-new_gold" style="background-color: #D4AF37;color:#fff;height:42px; text-transform: initial;">
                                            Register Business
                                        </a>
                                    </div>

@endsection


@section('content')	
	<div class="event-section section" style="background-color:#fff">
	        	<div class="row">	        
	            <div class="col-lg-12" data-aos="fade-up">
	                <div class="facilitate_box" style="background-color:#fff">
	                    <div class="register_block padtop_64">
	                        <iframe src="https://embeds.tiger.co.tz/user-registration" style="flex-grow: 1;height: 480px;border:none;"></iframe>

	                    </div>
	                </div>
	            </div>
	        </div>
	</div>

    
<div class="event-section section" style="background-color:#fff ;margin-top: -4px;">
			        <div class="row">	        
			            <div class="col-lg-12" data-aos="fade-up">
			                <div class="facilitate_box" style="border-radius:20px 20px 0px 0px;padding: 38px 40px 38px 40px; ">
			                    <div class="row register_block" style="">
			                        <div class="col-lg-4">
			                            <div style="">
			                            	
			                                <h3 class=" black mb-2"style="line-height: 42px;font-size:42px;margin-top:1em;font-weight:400">Grow your Business through Loyalty</h3>
			                                <p class="desc gil_light black font_16" style="line-height: 20px;">
			                                   Turn your customers into sales advocates by rewarding their purchasing and referral efforts. Tiger Loyalty offers you a way to set up sales campaigns and loyalty programs that drives active sales. 
			                                </p>
			                                <div class="row">

        	                                	<div class="col-4">
        	                                		<a href="/">
                                                  <img style="width: 220px;" src="/assets/images/tiger/apple_store.png" alt="">
                                                </a>
                                            </div>
                                                <div class="col-4">
                                                <a href="/">
                                                   <img style="width: 220px;" src="/assets/images/tiger/g_play.png" alt=""> 
                                                </a>
                                                </div>
        
        	                                </div>
			                                
			                            </div>
			                        </div>

			                        <div class="col-lg-8">
			                        	

			                        	<div class="">
			                        		<section class="testimonials">
			                        		   <div class="inner-testimonials">
			                        		      <div class="owl-carousel custome_slide" id="slide-testimonal">
			                        		         
			                        		       @foreach($deals as $featured_deal)
			                        		       @php
			                        		       $vendorr = Vendor::where('id',$featured_deal->vendorid)->first();
			                        		       @endphp
			                        		
			                        		   <div class="test_img">
			                        		      <div class="main-reviewimage">
			                        		         <img src="https://tigeradmin.testing.co.tz{{$featured_deal->featured_image}}" alt="{{$vendorr->name}}">
			                        		      </div>
			                        		   </div>

			                        		           
			                        		        @endforeach

			                        		      </div>
			                        		   </div>
			                        		</section>

			                        	</div>

			                        </div>

			                    </div>
			                </div>
			            </div>
			        </div>
			</div>
@endsection

@push('extrajs')
 <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

 <script>
 	$(document).ready(function(){
    $('input[name=landing_content]').on('change', function(){
    var n = $(this).val();
    switch(n)
    {
            case '1':
                  window.location.replace('/');
                  break;
            case '2':
                  window.location.replace('/customer');
                  break;
        }
    });
});

 </script>

 <script>
   $('#slide-testimonal').owlCarousel({
	margin: 0,
	center: true,
	loop: true,
	nav: true,
	responsive: {
	0: {
	   items: 1
	},
	768: {
	   items: 2,
	margin: 15,
	},
	1000: {
	   items: 3,
	}
    }
});

</script>
@endpush